
/*========================================================================================*/
var terminContainer = document.getElementById("termincontainer");
var klassennameLabel = document.getElementById("klassenname");
var terminContainerLeer = document.getElementById("termincontainer").cloneNode(true);
var dialogFenster;
var stundenplan = new Stundenplan(terminContainer, klassennameLabel);
var terminmuster = document.getElementById("termin_muster");
var dialogId = 0;

/*========================================================================================*/
function closeDialog(){
	dialogFenster.close();
	dialogId = 0;
}
/*========================================================================================*/
function stundenplanNeu(){
	stundenplan.neu();
}
function stundenplanOeffnen(){
	var optionen = 'dependent=yes,' +
				   ' height=250,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogFenster = window.open('StundenplanListe.xul','Liste der Stundenplne',optionen);
}
function stundenplanSpeichern(){
	var nachricht;
	var planStatus = stundenplan.getStatus();
	if(planStatus=='ok'){
		stundenplan.speichern();
		return;
	}
	else if(planStatus=='lehrer') nachricht = 'Sie haben noch nicht allen Faechern Lehrer zugeteilt!';
	else if(planStatus=='raum') nachricht = 'Sie haben noch nicht allen Faechern Raeume zugeteilt!';
	else if(planStatus=='klasse') nachricht = 'Sie haben die Klasse noch nicht ausgewhlt, fuer die dieser Plan gelten soll!';
	else nachricht = 'Irgendetwas stimmt hier nicht...';
	alert(nachricht);
}
/*========================================================================================*/
function klasseNeu(id){
	var optionen = 'dependent=yes,' +
				   ' height=140,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogId = id;
	dialogFenster = window.open('KlasseDialog.xul','Neue Klasse',optionen);
}

function klasseHinzu(){
	var optionen = 'dependent=yes,' +
				   ' height=350,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogId = "hinzu";
	dialogFenster = window.open('KlassenListe.xul','Liste der Klassen',optionen);
}
function klasseBearbeiten(){
	var optionen = 'dependent=yes,' +
				   ' height=350,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogFenster = window.open('KlassenListe.xul','Liste der Klassen',optionen);
}
/*========================================================================================*/
function fachNeu(id){
	var optionen = 'dependent=yes,' +
				   ' height=140,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogId = id;
	dialogFenster = window.open('FachDialog.xul','Neues Fach',optionen);
}
function fachHinzu(){
	var optionen = 'dependent=yes,' +
				   ' height=350,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogId = "hinzu";
	dialogFenster = window.open('FachListe.xul','Liste der Fcher',optionen);
}
function fachZuPlan(id,name,farbe){
	var fach = new Fach();
	fach.setId(id);
	fach.setName(name);
	fach.setFarbe(farbe);
	neuerTermin = new Termin(terminmuster.cloneNode(true));
	neuerTermin.setFach(fach);
	neuerTermin.setTag(1);
	var stunde = 8 + stundenplan.terminCounter;
	stundenplan.terminCounter++;
	if(stundenplan.terminCounter>=stundenplan.terminCounterReset) stundenplan.terminCounter = 0;
	neuerTermin.setBeginn(stunde+':00');
	stundenplan.terminHinzufuegen(neuerTermin);
}
function fachBearbeiten(){
	var optionen = 'dependent=yes,' +
				   ' height=350,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogFenster = window.open('FachListe.xul','Liste der Fcher',optionen);
}
/*========================================================================================*/
function lehrerNeu(id){
	var optionen = 'dependent=yes,' +
				   ' height=140,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogId = id;
	dialogFenster = window.open('LehrerDialog.xul','Neuer Lehrer',optionen);
}

function lehrerHinzu(){
	if(stundenplan.getAktuellerTermin()==null){
		alert('Bitte waehlen Sie zuerst ein Fach auf dem Stundenplan aus!');
		return;
	}
	var optionen = 'dependent=yes,' +
				   ' height=350,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogId = "hinzu";
	dialogFenster = window.open('LehrerListe.xul','Liste der Lehrer',optionen);	
}
function lehrerZuFach(id, anrede, vorname, nachname){
	var lehrer = new Lehrer();
	lehrer.setId(id);
	lehrer.setAnrede(anrede);
	lehrer.setVorname(vorname);
	lehrer.setNachname(nachname);
	stundenplan.getAktuellerTermin().setLehrer(lehrer);
}
function lehrerBearbeiten(){
	var optionen = 'dependent=yes,' +
				   ' height=350,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogFenster = window.open('LehrerListe.xul','Liste der Lehrer',optionen);
}
/*========================================================================================*/
function raumNeu(id){
	var optionen = 'dependent=yes,' +
				   ' height=140,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogId = id;
	dialogFenster = window.open('RaumDialog.xul','Neuer Lehrer',optionen);
}
function raumHinzu(){
	if(stundenplan.getAktuellerTermin()==null){
		alert('Bitte waehlen Sie zuerst ein Fach auf dem Stundenplan aus!');
		return;
	}
	var optionen = 'dependent=yes,' +
				   ' height=350,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogId = "hinzu";
	dialogFenster = window.open('RaumListe.xul','Liste der Rume',optionen);	
}
function raumZuFach(id, name){
	var raum = new Raum();
	raum.setId(id);
	raum.setName(name);
	stundenplan.getAktuellerTermin().setRaum(raum);
} 
function raumBearbeiten(){
	var optionen = 'dependent=yes,' +
				   ' height=350,' +
				   ' width=320,' +
				   ' menubar=no,' +
				   ' resizable=no,' +
				   ' scrollbars=no,' +
				   ' status=no,' +
				   ' toolbar=no' +
				   ' modal=yes';
	dialogFenster = window.open('RaumListe.xul','Liste der Lehrer',optionen);
}
/*========================================================================================*/

function Stundenplan(terminContainer, klassennameLabel ){
	this.terminCounter=0;
	this.terminCounterReset=10;
	var sender;
	var empfaenger;
	var termine = new Array();
	var klasse = new Klasse();
	var view = terminContainer;
	var klassenLabel = klassennameLabel;
	view.model = this;
	var aktuellerTermin = null;
	
	this.startdrag = function(fachVordergrund){
		var terminView = fachVordergrund.parentNode.parentNode.parentNode;
		this.setAktuellerTermin(terminView.model);
		document.addEventListener('mousemove',stundenplan.drag,true);
		document.addEventListener('mouseup',stundenplan.drop,true);
	}
	this.loeschen = function(){
		var anzahl=termine.length;
		for(var i = (anzahl-1);i >=0;i--){
			var tmptermin = termine.pop();
			tmptermin.loeschen();
		}

	}
	this.drag = function(event){
		var offset = 32;
		var x = event.layerX-offset;
		var y = event.layerY-50;
		//Nur sprunghafte Bewegung von Tag zu Tag in X-Richtung:
		var rest = x%(140); 
		x-=rest;
		//Begrenzung in X-Richtung:
		if(x < 0) x=0;
		else if(x > 840+offset) x=840;
		//Nur sprunghafte Bewegung in 15-Minuten-Schritten in Y-Richtung:
		rest = y%15;
		y-=rest;
		//Begrenzung in Y-Richtung:
		if(y < 0) y=0;
		else if((y+aktuellerTermin.getHoehe()) > 720) y=720-aktuellerTermin.getHoehe();
		aktuellerTermin.setPosition(x,y);
	}
	this.getStatus = function(){
		var abbruch = false;
		for(var i =0;i<termine.length;i++){
			if(termine[i].getLehrer().getId()==0){
				return "lehrer";
			}
			else if(termine[i].getRaum().getId()==0){
				return "raum";
			}
			else if(termine[i].getKlasse().getId()==0){
				return "klasse";
			}
		}
		return "ok";
	}
	this.drop = function(event){
		var x = aktuellerTermin.getView().getAttribute('x') - 0;
		var y = aktuellerTermin.getView().getAttribute('y') - 0;
		aktuellerTermin.setZeitenMitPixel(x,y);
		document.removeEventListener('mousemove',stundenplan.drag,true);
		document.removeEventListener('mouseup',stundenplan.drop,true);
	}	
	this.startAnfassen = function(anfassobjekt){
		var terminView = anfassobjekt.parentNode.parentNode.parentNode;
		this.setAktuellerTermin(terminView.model);
		document.addEventListener('mousemove',stundenplan.anfassen,true);
		document.addEventListener('mouseup',stundenplan.stopAnfassen,true);	
	}
	this.anfassen = function(event){
		var terminY = aktuellerTermin.getView().getAttribute('y') - 0;
		var terminHoehe = aktuellerTermin.getHoehe();
		var yneu = event.layerY - 32;
		var yalt = terminY + terminHoehe;
		//alert('layerY: '+yneu+'|yalt: '+yalt);
		var hoeheneu = aktuellerTermin.getHoehe() - (yalt-yneu);
		var rest = hoeheneu%15;
		hoeheneu-=rest;
		if(hoeheneu < 60) hoeheneu = 60;
		if(hoeheneu + terminY > 720 ) hoeheneu = 720-terminY;
	
		//Nur sprunghafte Bewegung in 15-Minuten-Schritten in Y-Richtung:
		/*rest = y%15;
		y-=rest;
		//Begrenzung in Y-Richtung:
		if(y < 0) y=0;
		else if((y+aktuellerTermin.getHoehe()) > 720) y=720-aktuellerTermin.getHoehe();*/
		aktuellerTermin.setHoehe(hoeheneu);	
	}
	this.stopAnfassen = function(event){
		var x = aktuellerTermin.getView().getAttribute('x') - 0;
		var y = aktuellerTermin.getView().getAttribute('y') - 0;
		aktuellerTermin.setZeitenMitPixel(x,y);
		document.removeEventListener('mousemove',stundenplan.anfassen,true);
		document.removeEventListener('mouseup',stundenplan.stopAnfassen,true);
	}
	this.setKlasse = function(id, name){
		klasse = new Klasse();
		klasse.setId(id);
		klasse.setName(name);
		klassenLabel.value = name;
		for(var i =0;i<termine.length;i++){
			termine[i].setKlasse(klasse);
		}
	}
	
	this.getKlasse = function(){
		return klasse;
	}
		
	this.terminHinzufuegen = function(neuerTermin){
		neuerTermin.setKlasse(klasse);
		termine.push(neuerTermin);
		view.appendChild(neuerTermin.getView());
		neuerTermin.setVisibility(true);
		this.setAktuellerTermin(neuerTermin);		
	}
	
	this.setAktuellerTermin = function(neuerAktuellerTermin){
		if(aktuellerTermin!=null) aktuellerTermin.setStatus(false);
		aktuellerTermin = neuerAktuellerTermin;
		aktuellerTermin.setStatus(true);
	}
	this.getAktuellerTermin = function(){
		return aktuellerTermin;
	}
	
	this.speichern = function(){
		delete sender;
		sender = new XMLHttpRequest();
		var kommando = 'speichern=terminevonklasse';
		var xmlTermine = 'XML=<terminliste>';
		for(var i=0;i<termine.length;i++){
			xmlTermine+=termine[i].getXML();
		}
		xmlTermine+='</terminliste>';	
		//alert(xmlTermine);
		
		sender.open('POST', 'Server.php', true);
		sender.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
		sender.onreadystatechange = function () {
	        // Wenn der Objektstatus gleich 4 ist...
	        if (sender.readyState == 4) {
	          if(sender.responseXML.firstChild.nodeName == 'ok'){
	          	alert('Speichern erfolgreich!');
	          }
	          else{
	          	alert('Fehler beim Speichern:'+sender.responseText);
	          }
	        }
    	} 
    	sender.send(kommando+'&'+xmlTermine);
	}
	this.laden = function(terminliste){
		this.loeschen();
		
		var termin;
		var neueKlasse;
		var neuesFach;
		var neuerLehrer;
		var neuerRaum;
		for(var i=0;i<terminliste.length;i++){
			termin = new Termin(terminmuster.cloneNode(true));
			//termin.setId(terminliste[i].childNodes[0].firstChild.nodeValue);
			neueKlasse = new Klasse();
			neueKlasse.setId(terminliste[i].childNodes[1].childNodes[0].firstChild.nodeValue);
			neueKlasse.setName(terminliste[i].childNodes[1].childNodes[1].firstChild.nodeValue);
			neuesFach = new Fach();
			neuesFach.setId(terminliste[i].childNodes[2].childNodes[0].firstChild.nodeValue);
			neuesFach.setFarbe(terminliste[i].childNodes[2].childNodes[2].firstChild.nodeValue);
			neuesFach.setName(terminliste[i].childNodes[2].childNodes[1].firstChild.nodeValue);
			neuerLehrer = new Lehrer();
			neuerLehrer.setId(terminliste[i].childNodes[3].childNodes[0].firstChild.nodeValue);
			neuerLehrer.setAnrede(terminliste[i].childNodes[3].childNodes[1].firstChild.nodeValue);
			neuerLehrer.setVorname(terminliste[i].childNodes[3].childNodes[2].firstChild.nodeValue);
			neuerLehrer.setNachname(terminliste[i].childNodes[3].childNodes[3].firstChild.nodeValue);
			neuerRaum = new Raum();
			neuerRaum.setId(terminliste[i].childNodes[4].childNodes[0].firstChild.nodeValue);
			neuerRaum.setName(terminliste[i].childNodes[4].childNodes[1].firstChild.nodeValue);
			
			termin.setKlasse(neueKlasse);
			termin.setFach(neuesFach);
			termin.setLehrer(neuerLehrer);
			termin.setRaum(neuerRaum);
			
			
			termin.setBeginn(terminliste[i].childNodes[6].firstChild.nodeValue);
			termin.setEnde(terminliste[i].childNodes[7].firstChild.nodeValue);
			termin.setTag(terminliste[i].childNodes[5].firstChild.nodeValue); 
			this.terminHinzufuegen(termin);

		}
		this.setKlasse(neueKlasse.getId(),neueKlasse.getName());
		
	}	
	this.neu = function(){
		window.location.reload();
	}
}
/*========================================================================================*/
function Termin(terminView){
	var id = 0;
	var klasse = new Klasse();
	var fach = new Fach();
	var lehrer = new Lehrer();
	var raum = new Raum();
	var tag = 0;
	var beginn = "00:00";
	var ende = "00:00";
	var view = terminView;
	view.model = this;
	var status = false;
	
	this.getView = function(){
		return view;
	}
	this.setPosition = function(x,y){
		this.getView().setAttribute("x",x);
		this.getView().setAttribute("y",y);
	}
	this.setZeitenMitPixel = function(x,y){
		var y2 = (this.getHoehe() + y);
		var tmptag = (x/140)+1;
		tag = tmptag;
		var tmpbeginnStd = Math.floor(y/60)+8;
		var tmpbeginnMin = (y%60);
		beginn = (tmpbeginnStd+':'+tmpbeginnMin);
		var tmpendeStd = Math.floor(y2/60)+8;
		var tmpendeMin = (y2%60);
		ende = (tmpendeStd+':'+tmpendeMin);
	}
	this.getHoehe = function(){
		return (view.childNodes[1].childNodes[1].childNodes[1].getAttribute("height") - 0);
	}
	this.setHoehe = function(hoehe){
		view.childNodes[1].childNodes[1].childNodes[1].setAttribute("height",hoehe);
		view.childNodes[1].childNodes[1].childNodes[3].setAttribute("height",(hoehe-8));
		view.childNodes[1].childNodes[1].childNodes[5].setAttribute("y",(hoehe-4));
	}
	this.setStatus = function(wert){
		status = wert;
		var farbe;
		var fill;
		var stroke;
		if(status==true){
			fill = "#FFFFFF";
		}
		else{
			fill = "url(#farbverlauf_termin)";
		}
		view.childNodes[1].childNodes[1].childNodes[1].setAttribute("fill",fill);
	}
	this.setVisibility = function(value){
		if(value==true) value = "visible";
		else value = "hidden";
		view.setAttribute("visibility",value);	
	}
	
	this.setId = function(neueId){
		id = newId;
	}
	this.getId = function(){
		return id;
	}
	this.getKlasse = function(){
		return klasse;
	}
	this.setKlasse = function(neueKlasse){
		klasse = neueKlasse;
	}
	this.setFach = function(neuesFach){
		fach = neuesFach;
		view.childNodes[1].childNodes[1].childNodes[3].setAttribute("fill", '#'+fach.getFarbe());
		view.childNodes[1].childNodes[3].childNodes[1].firstChild.nodeValue = fach.getName();	
	}
	this.getFach = function(){
		return fach;
	}
	this.getLehrer = function(){
		return lehrer;
	}
	this.setLehrer = function(neuerLehrer){
		lehrer = neuerLehrer;
		view.childNodes[1].childNodes[5].childNodes[1].firstChild.nodeValue = lehrer.getVorname()+" "+lehrer.getNachname();
	}
	this.getRaum = function(){
		return raum;
	}
	this.setRaum = function(neuerRaum){
		raum = neuerRaum;
		view.childNodes[1].childNodes[7].childNodes[1].firstChild.nodeValue = raum.getName();
	}
	this.setTag = function(neuerTag){
		tag = neuerTag;
		var tmpx = ((neuerTag-1)*140);
		this.getView().setAttribute("x",tmpx);
	}
	this.getTag = function(){
		return tag;
		
	}
	this.setBeginn = function(neuerBeginn){
		beginn = neuerBeginn;
		var zeit = neuerBeginn.split(':');
		var y = ((zeit[0]-8)*60) + (zeit[1]-0);
		this.getView().setAttribute("y",y);
		
	}
	this.getBeginn = function(){
		return beginn;
	}
	this.setEnde = function(neuesEnde){
		ende = neuesEnde;
		var zeit = neuesEnde.split(':');
		var tmphoehe = ((zeit[0]-8)*60) + (zeit[1]-0);
		tmphoehe -= this.getView().getAttribute("x");
		this.setHoehe(tmphoehe);
	}
	this.getEnde = function(){
		return ende;
	}
	this.getXML = function(){
		var xmlString = "<termin>" +
							"<id>"+this.getId()+"</id>" +
							this.getKlasse().getXML()+
							this.getFach().getXML()+
							this.getLehrer().getXML()+
							this.getRaum().getXML()+
							"<tag>"+this.getTag()+"</tag>" +
							"<beginn>"+this.getBeginn()+"</beginn>" +
							"<ende>"+this.getEnde()+"</ende>" +
						"</termin>";
		return xmlString;	
	}
	this.loeschen=function(){
		var viewParent=view.parentNode;
		viewParent.removeChild(view);
	}
	
}
/*========================================================================================*/
function Lehrer(){
	var id = 0;
	var anrede = "";
	var vorname = "";
	var nachname = "";
	
	this.setId = function(neueId){
		id = neueId;
	}
	this.getId = function(){
		return id;
	}
	this.getAnrede = function(){
		return anrede;
	}
	this.setAnrede = function(neueAnrede){
		anrede = neueAnrede;	
	}
	this.getVorname = function(){
		return vorname;
	}
	this.setVorname = function(neuerVorname){
		vorname = neuerVorname;	
	}
	this.getNachname = function(){
		return nachname;
	}
	this.setNachname = function(neuerNachname){
		nachname = neuerNachname;	
	}
	this.getXML = function(){
		var xmlString = "<lehrer>" +
							"<id>"+this.getId()+"</id>" +
							"<anrede>"+this.getAnrede()+"</anrede>" +
							"<vorname>"+this.getVorname()+"</vorname>" +
							"<nachname>"+this.getNachname()+"</nachname>" +
						"</lehrer>";
		return xmlString;	
	}
}
/*========================================================================================*/
function Klasse(){
	var id = 0;
	var name = "";
	var schuelerZahl = 0;
	
	this.setId = function(neueId){
		id = neueId;
	}
	this.getId = function(){
		return id;
	}
	this.getName = function(){
		return name;
	}
	this.setName = function(neuerName){
		name = neuerName;	
	}
	this.setSchuelerZahl = function(neueAnzahl){
		schuelerZahl = neueAnzahl;
	}
	this.getSchuelerZahl = function(){
		return schuelerZahl;
	}
	this.getXML = function(){
		var xmlString = "<klasse>" +
							"<id>"+this.getId()+"</id>" +
							"<name>"+this.getName()+"</name>" +
							"<schuelerzahl>"+this.getSchuelerZahl()+"</schuelerzahl>" +
						"</klasse>";
		return xmlString;	
	}
}
/*========================================================================================*/
function Fach(){
	var id = 0;
	var name = "";
	var farbe = "#CCCCCC";
	var beschreibung = "";
	
	this.setId = function(neueId){
		id = neueId;
	}
	this.getId = function(){
		return id;
	}
	this.getName = function(){
		return name;
	}
	this.setName = function(neuerName){
		name = neuerName;	
	}
	this.setFarbe = function(neueFarbe){
		farbe = neueFarbe;
	}
	this.getFarbe = function(){
		return farbe;
	}
	this.setBeschreibung = function(neueBeschreibung){
		beschreibung = neueBeschreibung;
	}
	this.getBeschreibung = function(){
		return beschreibung;
	}
	this.getXML = function(){
		var xmlString = "<fach>" +
							"<id>"+this.getId()+"</id>" +
							"<name>"+this.getName()+"</name>" +
							"<farbe>"+this.getFarbe()+"</farbe>" +
							"<beschreibung>"+this.getBeschreibung()+"</beschreibung>" +
						"</fach>";
		return xmlString;	
	}
}
/*========================================================================================*/
function Raum(){
	var id = 0;
	var name = "";
	var kapazitaet = 0;
	
	this.setId = function(neueId){
		id = neueId;
	}
	this.getId = function(){
		return id;
	}
	this.getName = function(){
		return name;
	}
	this.setName = function(neuerName){
		name = neuerName;	
	}
	this.getKapazitaet = function(){
		return kapazitaet;
	}
	this.setKapazitaet = function(neueKapazitaet){
		kapazitaet = neueKapazitaet;	
	}
	this.getXML = function(){
		var xmlString = "<raum>" +
							"<id>"+this.getId()+"</id>" +
							"<name>"+this.getName()+"</name>" +
							"<kapazitaet>"+this.getKapazitaet()+"</kapazitaet>" +
						"</raum>";
		return xmlString;	
	}
}
/*========================================================================================*/